# cPanel Backend API Test Kılavuzu

## API'nin Çalışıp Çalışmadığını Kontrol Etme

### 1. Manuel Test (Tarayıcı ile)
Aşağıdaki URL'leri tarayıcınızda açın:

```
http://api.melinajans.com/api/categories
http://api.melinajans.com/api/candidates  
http://api.melinajans.com/api/customers
http://api.melinajans.com/api/selections
http://api.melinajans.com/api/cities
```

**Beklenen Sonuç:** JSON formatında veri veya boş array `[]`

### 2. Otomatik Test (Node.js ile)
```bash
node test-api.js
```

Bu script tüm endpoint'leri otomatik test eder ve rapor verir.

### 3. cURL ile Test
```bash
curl http://api.melinajans.com/api/categories
curl http://api.melinajans.com/api/candidates
```

### 4. Postman ile Test
1. Postman'ı açın
2. Yeni request oluşturun
3. Method: GET
4. URL: `http://api.melinajans.com/api/categories`
5. Send butonuna tıklayın

## Sorun Giderme

### Server Çalışmıyorsa:
```bash
# Server'ı başlatın
node server.js

# Hata mesajlarını kontrol edin
```

### Veritabanı Bağlantı Hatası:
- `db/api.js` dosyasındaki veritabanı bilgilerini kontrol edin
- MySQL sunucusunun çalıştığından emin olun
- Veritabanı ve tabloların oluşturulduğundan emin olun

### Port Çakışması:
- 3001 portunun kullanımda olup olmadığını kontrol edin
- Gerekirse `server.js` dosyasındaki portu değiştirin

## Başarılı Yanıtlar

### 200 OK - Başarılı
```json
[]
```
veya
```json
[
  {
    "id": "1",
    "name": "Kategori Adı",
    "description": "Açıklama",
    "created_at": "2025-01-01T00:00:00.000Z"
  }
]
```

### 500 Internal Server Error - Hata
```json
{
  "message": "Hata mesajı"
}
```

## Log Kontrolü
Server loglarını izlemek için:
```bash
node server.js
```

Console'da görmelisiniz:
```
Backend server http://localhost:3001 adresinde çalışıyor
