const mysql = require('mysql2/promise');
const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');

const dbConfig = {
  host: '217.18.85.207',
  user: 'melinajans_ajans',
  password: 'Furkan1453',
  database: 'melinajans_ajans',
  charset: 'utf8mb4'
};

async function getConnection() {
  return await mysql.createConnection(dbConfig);
}

const db = {
  // Categories
  getCategories: async () => {
    const connection = await getConnection();
    try {
      const [rows] = await connection.execute('SELECT * FROM categories');
      return rows;
    } finally {
      connection.end();
    }
  },
  createCategory: async (categoryData) => {
    const connection = await getConnection();
    try {
      const id = Math.random().toString(36).substr(2, 9);
      const now = new Date().toISOString().slice(0, 19).replace('T', ' ');
      const sql = `INSERT INTO categories (id, name, description, created_at) VALUES (?, ?, ?, ?)`;
      const values = [id, categoryData.name, categoryData.description || null, now];
      await connection.execute(sql, values);
      const newCategory = {
        id,
        name: categoryData.name,
        description: categoryData.description,
        created_at: now
      };
      return newCategory;
    } finally {
      connection.end();
    }
  },
  updateCategory: async (id, updates) => {
    const connection = await getConnection();
    try {
      const updateFields = [];
      const updateValues = [];
      if (updates.name) {
        updateFields.push('name = ?');
        updateValues.push(updates.name);
      }
      if (updates.description !== undefined) {
        updateFields.push('description = ?');
        updateValues.push(updates.description);
      }
      if (updateFields.length === 0) return;
      const sql = `UPDATE categories SET ${updateFields.join(', ')} WHERE id = ?`;
      await connection.execute(sql, [...updateValues, id]);
    } finally {
      connection.end();
    }
  },
  deleteCategory: async (id) => {
    const connection = await getConnection();
    try {
      const sql = `DELETE FROM categories WHERE id = ?`;
      await connection.execute(sql, [id]);
    } finally {
      connection.end();
    }
  },

  // Candidates
  getCandidates: async (filters) => {
    const connection = await getConnection();
    try {
      let sql = 'SELECT c.*, cat.name as category_name FROM candidates c LEFT JOIN categories cat ON c.category_id = cat.id';
      const whereConditions = [];
      const values = [];
      
      if (filters?.status) {
        whereConditions.push('c.status = ?');
        values.push(filters.status);
      }
      if (filters?.category) {
        whereConditions.push('c.category_id = ?');
        values.push(filters.category);
      }
      if (filters?.city) {
        whereConditions.push('c.city = ?');
        values.push(filters.city);
      }
      if (filters?.minHeight !== undefined) {
        whereConditions.push('c.height >= ?');
        values.push(filters.minHeight);
      }
      if (filters?.maxHeight !== undefined) {
        whereConditions.push('c.height <= ?');
        values.push(filters.maxHeight);
      }
      if (filters?.minWeight !== undefined) {
        whereConditions.push('c.weight >= ?');
        values.push(filters.minWeight);
      }
      if (filters?.maxWeight !== undefined) {
        whereConditions.push('c.weight <= ?');
        values.push(filters.maxWeight);
      }
      if (filters?.minAge !== undefined || filters?.maxAge !== undefined) {
        if (filters.minAge !== undefined) {
          whereConditions.push('TIMESTAMPDIFF(YEAR, c.birth_date, CURDATE()) >= ?');
          values.push(filters.minAge);
        }
        if (filters.maxAge !== undefined) {
          whereConditions.push('TIMESTAMPDIFF(YEAR, c.birth_date, CURDATE()) <= ?');
          values.push(filters.maxAge);
        }
      }
      if (filters?.languages && filters.languages.length > 0) {
        const languageConditions = filters.languages.map(lang => {
          return `JSON_CONTAINS(c.languages, ?)`;
        });
        whereConditions.push(`(${languageConditions.join(' OR ')})`);
        filters.languages.forEach(lang => {
          values.push(JSON.stringify(lang));
        });
      }
      if (filters?.eyeColor) {
        whereConditions.push('c.eye_color = ?');
        values.push(filters.eyeColor);
      }
      if (filters?.hairColor) {
        whereConditions.push('c.hair_color = ?');
        values.push(filters.hairColor);
      }
      
      if (whereConditions.length > 0) {
        sql += ' WHERE ' + whereConditions.join(' AND ');
      }

      console.log('Final SQL:', sql);
      console.log('SQL Values:', values);
      const [rows] = await connection.execute(sql, values);
      const candidates = rows;
      
      return candidates.map(candidate => ({
        ...candidate,
        category: candidate.category_name ? {
          id: candidate.category_id,
          name: candidate.category_name
        } : undefined,
        languages: candidate.languages ? JSON.parse(candidate.languages) : [],
        photos: candidate.photos ? JSON.parse(candidate.photos) : [],
        available_dates: candidate.available_dates ? JSON.parse(candidate.available_dates) : []
      }));
    } finally {
      connection.end();
    }
  },

  // Selections
  getSelections: async () => {
    const connection = await getConnection();
    try {
      const [rows] = await connection.execute('SELECT * FROM selections');
      return rows;
    } finally {
      connection.end();
    }
  },

  createSelection: async (selectionData) => {
    const connection = await getConnection();
    try {
      const id = Math.random().toString(36).substr(2, 9);
      const share_token = Math.random().toString(36).substr(2, 12);
      const now = new Date().toISOString().slice(0, 19).replace('T', ' ');
      
      const sql = `INSERT INTO selections (
        id, name, description, share_token, status, created_at, updated_at, customer_name, customer_email
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)`;
      
      const values = [
        id,
        selectionData.name,
        selectionData.description || null,
        share_token,
        'draft',
        now,
        now,
        selectionData.customer_name,
        selectionData.customer_email
      ];

      await connection.execute(sql, values);
      
      const newSelection = {
        id,
        name: selectionData.name,
        description: selectionData.description,
        share_token: share_token,
        status: 'draft',
        created_at: now,
        updated_at: now,
        customer_name: selectionData.customer_name,
        customer_email: selectionData.customer_email,
        candidates: []
      };

      return newSelection;
    } finally {
      connection.end();
    }
  },

  deleteSelection: async (selectionId) => {
    const connection = await getConnection();
    try {
      await connection.execute('DELETE FROM selection_candidates WHERE selection_id = ?', [selectionId]);
      await connection.execute('DELETE FROM selections WHERE id = ?', [selectionId]);
    } finally {
      connection.end();
    }
  },

  // User Authentication
  authenticateUser: async (loginData) => {
    const connection = await getConnection();
    try {
      const [rows] = await connection.execute('SELECT * FROM users WHERE username = ? AND is_active = TRUE', [loginData.username]);
      const users = rows;
      
      if (users.length === 0) {
        return { user: null, token: null, message: 'Kullan1c1 ad1 veya _ifre hatal1' };
      }
      
      const user = users[0];
      const isValidPassword = await bcrypt.compare(loginData.password, user.password_hash);
      
      if (!isValidPassword) {
        return { user: null, token: null, message: 'Kullan1c1 ad1 veya _ifre hatal1' };
      }
      
      const now = new Date().toISOString().slice(0, 19).replace('T', ' ');
      await connection.execute('UPDATE users SET last_login = ? WHERE id = ?', [now, user.id]);
      
      const token = jwt.sign(
        { userId: user.id, username: user.username, role: user.role },
        'your-secret-key-change-in-production',
        { expiresIn: '24h' }
      );
      
      const userResponse = {
        id: user.id,
        username: user.username,
        email: user.email,
        full_name: user.full_name,
        role: user.role,
        is_active: user.is_active,
        last_login: now,
        created_at: user.created_at,
        updated_at: now
      };
      
      return { user: userResponse, token, message: 'Giri_ ba_ar1l1' };
    } finally {
      connection.end();
    }
  },

  verifyToken: async (token) => {
    try {
      const decoded = jwt.verify(token, 'your-secret-key-change-in-production');
      const user = await db.getUserById(decoded.userId);
      return user;
    } catch (error) {
      return null;
    }
  },

  getUserById: async (userId) => {
    const connection = await getConnection();
    try {
      const [rows] = await connection.execute('SELECT * FROM users WHERE id = ? AND is_active = TRUE', [userId]);
      const users = rows;
      return users.length > 0 ? users[0] : null;
    } finally {
      connection.end();
    }
  }
};

module.exports = { db };